/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;

public class TextureAttributesState
extends NodeComponentState {
    private static final int MAX_COLOR_OPERANDS = 2;

    public TextureAttributesState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        int n2;
        super.writeObject(dataOutput);
        TextureAttributes textureAttributes = (TextureAttributes)this.node;
        Color4f color4f = new Color4f();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D = new Transform3D();
        int n3 = textureAttributes.getNumTextureColorTableComponents();
        int n4 = textureAttributes.getTextureColorTableSize();
        int[][] nArray = new int[n3][n4];
        dataOutput.writeInt(textureAttributes.getPerspectiveCorrectionMode());
        textureAttributes.getTextureBlendColor(color4f);
        this.control.writeColor4f(dataOutput, color4f);
        dataOutput.writeInt(n3);
        dataOutput.writeInt(n4);
        textureAttributes.getTextureColorTable(nArray);
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n4; ++i2) {
                dataOutput.writeInt(nArray[n2][i2]);
            }
        }
        dataOutput.writeInt(textureAttributes.getTextureMode());
        textureAttributes.getTextureTransform(transform3D);
        transform3D.get(matrix4d);
        this.control.writeMatrix4d(dataOutput, matrix4d);
        dataOutput.writeInt(textureAttributes.getCombineRgbMode());
        dataOutput.writeInt(textureAttributes.getCombineAlphaMode());
        for (n2 = 0; n2 < 2; ++n2) {
            dataOutput.writeInt(textureAttributes.getCombineRgbSource(n2));
            dataOutput.writeInt(textureAttributes.getCombineAlphaSource(n2));
            dataOutput.writeInt(textureAttributes.getCombineRgbFunction(n2));
            dataOutput.writeInt(textureAttributes.getCombineAlphaFunction(n2));
        }
        dataOutput.writeInt(textureAttributes.getCombineRgbScale());
        dataOutput.writeInt(textureAttributes.getCombineAlphaScale());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        TextureAttributes textureAttributes = (TextureAttributes)this.node;
        textureAttributes.setPerspectiveCorrectionMode(dataInput.readInt());
        textureAttributes.setTextureBlendColor(this.control.readColor4f(dataInput));
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int[][] nArray = new int[n2][n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray[i2][i3] = dataInput.readInt();
            }
        }
        if (n2 != 0) {
            textureAttributes.setTextureColorTable(nArray);
        }
        textureAttributes.setTextureMode(dataInput.readInt());
        Matrix4d matrix4d = this.control.readMatrix4d(dataInput);
        Transform3D transform3D = new Transform3D(matrix4d);
        textureAttributes.setTextureTransform(transform3D);
        textureAttributes.setCombineRgbMode(dataInput.readInt());
        textureAttributes.setCombineAlphaMode(dataInput.readInt());
        for (int i4 = 0; i4 < 2; ++i4) {
            textureAttributes.setCombineRgbSource(i4, dataInput.readInt());
            textureAttributes.setCombineAlphaSource(i4, dataInput.readInt());
            textureAttributes.setCombineRgbFunction(i4, dataInput.readInt());
            textureAttributes.setCombineAlphaFunction(i4, dataInput.readInt());
        }
        textureAttributes.setCombineRgbScale(dataInput.readInt());
        textureAttributes.setCombineAlphaScale(dataInput.readInt());
    }

    protected SceneGraphObject createNode() {
        return new TextureAttributes();
    }
}

